*Convert csv files to STATA files, and first adjustments of files

*Tim Goedemé, 10 July 2020

*Globals

global place1 ...\EU-SILC\Cross\2020-04\
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IS IT LT LU LV MT NL NO PL PT RO RS SE SI SK UK

global years 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18

*Step 1: convert csv files to stata files

local counter1=0
foreach ctry of global countries {
	local counter1 = `counter1'+1
	di "******************"
	di "Now working on: `counter1' `ctry'"
	di "******************"
	local counter=0
	forvalues year = 2004(1)2018 {
		local counter= `counter'+1
		local yr = word("${years}", `counter')
		foreach dat in D H P R { // mind the annoying file names for Greece until 2007 (EL folder, but GR in filenames)
		    local doGR=0
			cap confirm file "${place1}\`ctry'\\`year'\UDB_c`ctry'`yr'`dat'.csv"
			if "`ctry'"=="EL" & _rc!=0 {
			    local doGR=1
				cap confirm file "${place1}\`ctry'\\`year'\UDB_cGR`yr'`dat'.csv"
			}
			di _rc
			if _rc==0 {
				clear
				if `doGR'==0 import delim "${place1}\`ctry'\\`year'\\UDB_c`ctry'`yr'`dat'.csv"
				else import delim "${place1}\`ctry'\\`year'\UDB_cGR`yr'`dat'.csv"
				
				if "`ctry'"=="EL" { // Replace country code Greece with EL everywhere //
					cap replace db020="EL" if db020=="GR"
					cap replace hb020="EL" if hb020=="GR"
					cap replace pb020="EL" if pb020=="GR"
					cap replace rb020="EL" if rb020=="GR"
				}
				
				cap rename db010 year
				cap rename db020 country
				cap rename db030 hid
				cap rename hb010 year
				cap rename hb020 country
				cap rename hb030 hid
				cap rename pb010 year
				cap rename pb020 country
				cap rename pb030 pid
				cap rename rb010 year
				cap rename rb020 country
				cap rename rb030 pid
				cap rename rx030 hid
	
				save "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'`dat'.dta", replace
				
			
			}
	
		}
	}
}

*error in original do file; redo rename of GR to EL
local counter=0
forvalues year = 2004(1)2007 {
	foreach dat in D H P R { // mind the annoying file names for Greece until 2007 (EL folder, but GR in filenames)
		local ctry EL
		use "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'`dat'.dta", clear
		
		replace country="EL" if country=="GR"
		
		save "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'`dat'.dta", replace
	}

}




*Test: make overview of available datasets
cap mat drop results
local counter1=0
foreach ctry of global countries {
	cap mat drop tempmat
	forvalues year = 2004(1)2018 {
		foreach dat in D {
			cap confirm file "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'`dat'.dta"
			if _rc==0 local val=1
			else local val=0
			
			mat def tempmat = nullmat(tempmat), `val'
		}
	}
	mat def results = nullmat(results) \ tempmat
}
mat rownames results = ${countries}
mat colnames results  = 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18
mat li results

clear 
svmat results, names(matcol)

gen country=""
local counter
foreach ctry of global countries {
	local counter = `counter'+1
	replace country="`ctry'" in `counter'
}

foreach year of global years {
	local jaar 20`year'
	rename results`year' year_`jaar'
	
}
compress
save "${place1}\SILCavailability.dta", replace

*Step 2: erase redundant files

local counter1=0
foreach ctry of global countries {
	local counter1 = `counter1'+1
	di "******************"
	di "Now working on: `counter1' `ctry'"
	di "******************"
	local counter=0
	forvalues year = 2004(1)2018 {
		local counter= `counter'+1
		local yr = word("${years}", `counter')
		foreach dat in D H P R {
			cap confirm file "${place1}\`ctry'\\`year'\UDB_c`ctry'`yr'`dat'.csv"
			if _rc==0 {
				clear
				erase "${place1}\`ctry'\\`year'\\UDB_c`ctry'`yr'`dat'.csv"
			
			}
	
		}
	}
}



























